# -*- coding: utf-8 -*-
"""
Created on Fri Jun 17 13:43:29 2022

@author: reinoutubbink
"""
import numpy as np
import matplotlib.pyplot as plt
import glob
import os

plt.close('all')
DOS = np.loadtxt('DOSBASE10.txt')
energy = np.arange(-0.4,-2.3,-DOS[1])

CVs = []
names = []

for filename in glob.glob('*.csv'):
   with open(os.path.join(os.getcwd(), filename), 'r') as f: # open in readonly mode
       curtemp = np.loadtxt(f, delimiter = '\t')
       CVs.append(curtemp)
       name=filename.split('\\')[-1]
       names.append(name)
      
plt.figure('Normal DOS')
ax1 = plt.axes()
ax2 = ax1.twiny()
ax3 = ax2.twinx()
ax1.plot(CVs[0][:,0]-0.3,CVs[0][:,1]*10000,color='black',linewidth=2)
ax1.plot(CVs[1][:,0]-0.3,CVs[1][:,1]*1000,color='red',linewidth=2)
ax1.plot(CVs[2][:,0]-0.3,CVs[2][:,1]*10000,color='black',linestyle = '--',linewidth=2)
ax1.plot(CVs[3][:,0]-0.3,CVs[3][:,1]*1000,color='red',linestyle = '--',linewidth=2)
ax3.plot(energy,DOS[3:]/1e26,color='#29ABE2',linewidth=2)
ax1.set_xlabel('WE bias (V)', size = '15') 
ax1.set_ylabel('Current density (mA/cm^2)/scan rate', size = '15')
ax3.set_ylabel('Density of states (*1e20 cm-3 eV-1)',color='b', size = '15')
ax1.yaxis.set_ticks([-5,-4,-3,-2,-1,0,1,2,3,4,5])
ax1.set_ylim([-5,5])
ax3.set_ylim([-4.5,4.5])
ax1.set_xticklabels([-1.2,-1.0,-0.8,-0.6,-0.4,-0.2])
new_tick_locations = np.array([-1.2,-1.0,-0.8,-0.6,-0.4,-0.2])
ax1.set_xlim([-1.32,-0.2])
ax2.set_xlim(ax1.get_xlim())
ax2.set_xticks(new_tick_locations)
ax2.set_xticklabels([-3.8,-4.0,-4.2,-4.4,-4.6,-4.8])
ax1.tick_params(length=10, width=3,labelsize='25')
ax2.tick_params(length=10, width=3,labelsize='25')
ax3.tick_params(length=10, width=3,color='#29ABE2',labelsize='25',labelcolor='#29ABE2')

fig = plt.gcf()
fig.set_size_inches(10, 7, forward=True)
plt.margins(x=0.01,y=0.1)

DOS2 = np.loadtxt('DOS_QD_GS.txt')
energy = np.arange(-0.4,-2.3,-DOS2[1])
plt.figure('adapted DOS')
ax4 = plt.axes()
ax5 = ax4.twiny()
ax6 = ax5.twinx()
ax4.plot(CVs[4][:,0]-0.3,CVs[4][:,1]*10000,color='black',linewidth=2)
ax4.plot(CVs[5][:,0]-0.3,CVs[5][:,1]*1000,color='red',linewidth=2)
ax6.plot(energy,DOS2[3:]/1e26,color='#29ABE2',linewidth=2)
ax4.set_xlabel('WE bias (V)', size = '15') 
ax4.set_ylabel('Current density (mA/cm^2)/scan rate', size = '15')
ax6.set_ylabel('Density of states (*1e20 cm-3 eV-1)',color='g', size = '15')
ax4.yaxis.set_ticks([-5,-4,-3,-2,-1,0,1,2,3,4,5])
ax4.set_ylim([-5,5])
ax6.set_ylim([-5.1,5.1])
#ax1.set_xticklabels([-1.2,-1.0,-0.8,-0.6,-0.4,-0.2])
new_tick_locations = np.array([-1.2,-1.0,-0.8,-0.6,-0.4,-0.2])
ax4.set_xlim([-1.32,-0.2])
ax5.set_xlim(ax1.get_xlim())
ax5.set_xticks(new_tick_locations)
ax5.set_xticklabels([-3.8,-4.0,-4.2,-4.4,-4.6,-4.8])
ax4.tick_params(length=10, width=3,labelsize='25')
ax5.tick_params(length=10, width=3,labelsize='25')
ax6.tick_params(length=10, width=3,color='#29ABE2',labelsize='25',labelcolor='#29ABE2')

fig = plt.gcf()
fig.set_size_inches(10, 7, forward=True)
plt.xlabel('Applied potential (V)', size = '15')
plt.ylabel('Current density (A/cm2)', size = '15')
plt.margins(x=0.01,y=0.1)